<?php
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\SettingController;
use App\Models\Category;
use Illuminate\Http\Request;

Route::get('/', [ExpenseController::class,'index'])->name('expenses.index');
Route::get('/expenses/create', [ExpenseController::class,'create'])->name('expenses.create');
Route::post('/expenses', [ExpenseController::class,'store'])->name('expenses.store');
Route::delete('/expenses/{expense}', [ExpenseController::class,'destroy'])->name('expenses.destroy');

Route::get('/export/expenses', [ExportController::class,'expenses'])->name('export.expenses');

Route::view('/categories', 'categories.index')->name('categories.index');
Route::post('/categories', function(Request $r){
  $r->validate(['name'=>['required','max:255'],'budget'=>['nullable','numeric','min:0']]);
  Category::create($r->only('name','budget'));
  return back()->with('ok','Kategorie hinzugefügt');
})->name('categories.store');

Route::get('/settings', [SettingController::class,'edit'])->name('settings.edit');
Route::post('/settings', [SettingController::class,'update'])->name('settings.update');
