<x-layout :title="'Budget & Ankauf'">
  <form method="post" action="{{ route('settings.update') }}" class="mx-auto max-w-3xl space-y-6 rounded-xl border bg-white p-6 shadow-sm">
    @csrf

    <fieldset>
      <legend class="text-lg font-semibold">Sanierungsbudget</legend>
      <div class="mt-3 grid grid-cols-1 gap-4 sm:grid-cols-2">
        <label class="block text-sm">Gesamtbudget (€)
          <input type="number" name="total_budget" step="0.01" value="{{ $totalBudget }}" class="mt-1 w-full rounded-md border-gray-300" />
        </label>
      </div>
    </fieldset>

    <fieldset>
      <legend class="text-lg font-semibold">Ankauf (NRW, ohne Makler)</legend>
      <div class="mt-3 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <label class="block text-sm sm:col-span-3">Kaufpreis (€)
          <input type="number" name="purchase_price" step="0.01" value="{{ $purchasePrice }}" class="mt-1 w-full rounded-md border-gray-300" />
        </label>
        <label class="block text-sm">Grunderwerbsteuer NRW (%)
          <input type="number" name="grunderwerbsteuer_rate" step="0.1" min="0" max="100" value="{{ $grEStRate }}" class="mt-1 w-full rounded-md border-gray-300" />
        </label>
        <label class="block text-sm">Notar + Grundbuch (%)
          <input type="number" name="notary_land_reg_rate" step="0.1" min="0" max="100" value="{{ $notaryRate }}" class="mt-1 w-full rounded-md border-gray-300" />
        </label>
      </div>
      <p class="mt-2 text-xs text-gray-500">Hinweis: Maklerkosten werden hier nicht berücksichtigt.</p>
    </fieldset>

    <div class="flex justify-end gap-2">
      <a href="{{ route('expenses.index') }}" class="rounded-md border px-4 py-2 hover:bg-gray-50">Zur Übersicht</a>
      <button class="rounded-md bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">Speichern</button>
    </div>
  </form>
</x-layout>
