<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{ $title ?? 'Baukosten' }}</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config = { theme: { extend: { } } };</script>
</head>
<body class="bg-gray-50 text-gray-900">
  <header class="border-b bg-white">
    <div class="mx-auto max-w-6xl px-4 py-4 flex items-center justify-between">
      <div class="flex items-center gap-3">
        <div class="h-9 w-9 rounded-xl bg-indigo-600 text-white grid place-items-center font-bold">B</div>
        <h1 class="text-xl font-semibold">Baukosten</h1>
      </div>
      <nav class="flex gap-4 text-sm">
        <a class="hover:text-indigo-600" href="{{ route('expenses.index') }}">Übersicht</a>
        <a class="hover:text-indigo-600" href="{{ route('expenses.create') }}">Rechnung erfassen</a>
        <a class="hover:text-indigo-600" href="{{ route('categories.index') }}">Kategorien</a>
        <a class="hover:text-indigo-600" href="{{ route('settings.edit') }}">Budget</a>
      </nav>
    </div>
  </header>

  <main class="mx-auto max-w-6xl px-4 py-6">
    @if(session('ok'))
      <div class="mb-4 rounded-md border border-green-200 bg-green-50 px-4 py-3 text-green-800">{{ session('ok') }}</div>
    @endif
    {{ $slot }}
  </main>

  <footer class="mt-10 border-t bg-white">
    <div class="mx-auto max-w-6xl px-4 py-6 text-xs text-gray-500">
      © {{ date('Y') }} – Baukosten
    </div>
  </footer>
</body>
</html>
