<x-layout :title="'Übersicht'">
  <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
    <div class="lg:col-span-2">
      <form method="get" class="mb-4 grid grid-cols-1 gap-3 rounded-xl border bg-white p-4 shadow-sm sm:grid-cols-6">
        <select name="category_id" class="col-span-2 rounded-md border-gray-300">
          <option value="">Alle Kategorien</option>
          @foreach($perCategory as $c)
            <option value="{{ $c->id }}" @selected(request('category_id')==$c->id)>{{ $c->name }}</option>
          @endforeach
        </select>
        <input type="date" name="from" value="{{ request('from') }}" class="rounded-md border-gray-300" />
        <input type="date" name="to" value="{{ request('to') }}" class="rounded-md border-gray-300" />
        <input type="text" name="vendor" placeholder="Lieferant" value="{{ request('vendor') }}" class="col-span-2 rounded-md border-gray-300" />
        <div class="col-span-6 flex items-center gap-2">
          <button class="rounded-md bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">Filtern</button>
          <a class="rounded-md border px-4 py-2 hover:bg-gray-50" href="{{ route('export.expenses', request()->query()) }}">Excel-Export</a>
        </div>
      </form>

      <div class="mb-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <div class="rounded-xl border bg-white p-4 shadow-sm">
          <div class="text-sm text-gray-500">Gesamtbudget</div>
          <div class="mt-1 text-2xl font-semibold">{{ number_format($totalBudget,2,',','.') }} €</div>
        </div>
        <div class="rounded-xl border bg-white p-4 shadow-sm">
          <div class="text-sm text-gray-500">Ausgegeben</div>
          <div class="mt-1 text-2xl font-semibold">{{ number_format($spent,2,',','.') }} €</div>
        </div>
        <div class="rounded-xl border bg-white p-4 shadow-sm">
          <div class="text-sm text-gray-500">Rest</div>
          <div class="mt-1 text-2xl font-semibold">{{ number_format($remaining,2,',','.') }} €</div>
        </div>
      </div>

      <div class="rounded-xl border bg-white p-4 shadow-sm">
        <h3 class="mb-3 text-lg font-semibold">Rechnungen</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="text-left text-gray-500">
              <tr>
                <th class="py-2 pr-3">Datum</th>
                <th class="py-2 pr-3">Kategorie</th>
                <th class="py-2 pr-3">Lieferant</th>
                <th class="py-2 pr-3">Rechnungsnr.</th>
                <th class="py-2 pr-3">Netto</th>
                <th class="py-2 pr-3">MwSt %</th>
                <th class="py-2 pr-3">Brutto</th>
                <th class="py-2 pr-3">Datei</th>
                <th class="py-2"></th>
              </tr>
            </thead>
            <tbody class="divide-y">
              @foreach($expenses as $e)
                <tr class="align-top">
                  <td class="py-2 pr-3">{{ $e->date?->format('Y-m-d') }}</td>
                  <td class="py-2 pr-3">{{ optional($e->category)->name }}</td>
                  <td class="py-2 pr-3">{{ $e->vendor }}</td>
                  <td class="py-2 pr-3">{{ $e->invoice_number }}</td>
                  <td class="py-2 pr-3">{{ number_format($e->net_amount,2,',','.') }}</td>
                  <td class="py-2 pr-3">{{ number_format($e->tax_rate,2,',','.') }}</td>
                  <td class="py-2 pr-3 font-semibold">{{ number_format($e->gross_amount,2,',','.') }}</td>
                  <td class="py-2 pr-3">
                    @if($e->file_path)
                      <a class="text-indigo-600 hover:underline" target="_blank" href="{{ asset('storage/'.$e->file_path) }}">Öffnen</a>
                    @endif
                  </td>
                  <td class="py-2 text-right">
                    <form method="post" action="{{ route('expenses.destroy',$e) }}">
                      @csrf @method('DELETE')
                      <button class="rounded-md border px-2 py-1 text-xs hover:bg-gray-50" onclick="return confirm('Eintrag löschen?')">Löschen</button>
                    </form>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          {{ $expenses->links() }}
        </div>
      </div>
    </div>

    <div class="space-y-4">
      <div class="rounded-xl border bg-white p-4 shadow-sm">
        <h3 class="mb-3 text-lg font-semibold">Ankaufskosten (NRW, ohne Makler)</h3>
        <dl class="text-sm">
          <div class="flex justify-between py-1"><dt>Kaufpreis</dt><dd class="font-semibold">{{ number_format($purchasePrice,2,',','.') }} €</dd></div>
          <div class="flex justify-between py-1"><dt>Grunderwerbsteuer ({{ number_format($grEStRate,1,',','.') }} %)</dt><dd>{{ number_format($grESt,2,',','.') }} €</dd></div>
          <div class="flex justify-between py-1"><dt>Notar + Grundbuch ({{ number_format($notaryRate,1,',','.') }} %)</dt><dd>{{ number_format($notary,2,',','.') }} €</dd></div>
          <div class="flex justify-between py-2 border-t mt-2 pt-2"><dt class="font-semibold">Nebenkosten gesamt</dt><dd class="font-semibold">{{ number_format($ancillary,2,',','.') }} €</dd></div>
          <div class="flex justify-between py-1"><dt class="font-semibold">Gesamterwerb</dt><dd class="font-semibold">{{ number_format($totalAcquisition,2,',','.') }} €</dd></div>
        </dl>
      </div>

      <div class="rounded-xl border bg-white p-4 shadow-sm">
        <h3 class="mb-3 text-lg font-semibold">Kategorien</h3>
        <ul class="space-y-2 text-sm">
          @foreach($perCategory as $c)
            @php $spentC = (float)($c->spent ?? 0); $budget = (float)($c->budget ?? 0); $rest = $budget - $spentC; $pct = $budget > 0 ? min(100, max(0, round($spentC*100/$budget))) : 0; @endphp
            <li>
              <div class="flex justify-between"><div>{{ $c->name }}</div><div class="text-gray-600">{{ $c->budget? number_format($c->budget,2,',','.') .' €' : '—' }}</div></div>
              @if($c->budget)
                <div class="mt-1 h-2 w-full rounded-full bg-gray-200">
                  <div class="h-2 rounded-full bg-indigo-600" style="width: {{ $pct }}%"></div>
                </div>
                <div class="mt-1 flex justify-between text-xs text-gray-500">
                  <span>Ausgaben: {{ number_format($spentC,2,',','.') }} €</span>
                  <span>Rest: {{ number_format($rest,2,',','.') }} €</span>
                </div>
              @else
                <div class="text-xs text-gray-500">Ohne Budgetvorgabe · Ausgaben: {{ number_format($spentC,2,',','.') }} €</div>
              @endif
            </li>
          @endforeach
        </ul>
      </div>
    </div>
  </div>
</x-layout>
