<x-layout :title="'Rechnung erfassen'">
  <form method="post" action="{{ route('expenses.store') }}" enctype="multipart/form-data" class="mx-auto max-w-3xl space-y-4 rounded-xl border bg-white p-6 shadow-sm">
    @csrf
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
      <label class="block text-sm">Datum
        <input type="date" name="date" required value="{{ now()->toDateString() }}" class="mt-1 w-full rounded-md border-gray-300" />
      </label>
      <label class="block text-sm">Kategorie
        <select name="category_id" class="mt-1 w-full rounded-md border-gray-300">
          <option value="">—</option>
          @foreach($categories as $c)
            <option value="{{ $c->id }}">{{ $c->name }}</option>
          @endforeach
        </select>
      </label>
      <label class="block text-sm sm:col-span-2">Lieferant
        <input name="vendor" maxlength="255" class="mt-1 w-full rounded-md border-gray-300" />
      </label>
      <label class="block text-sm">Rechnungsnr.
        <input name="invoice_number" maxlength="255" class="mt-1 w-full rounded-md border-gray-300" />
      </label>
      <label class="block text-sm">Netto (€)
        <input type="number" step="0.01" min="0" name="net_amount" required class="mt-1 w-full rounded-md border-gray-300" />
      </label>
      <label class="block text-sm">MwSt (%)
        <input type="number" step="0.01" min="0" max="100" name="tax_rate" value="19" class="mt-1 w-full rounded-md border-gray-300" />
      </label>
      <label class="block text-sm sm:col-span-2">Datei (PDF/JPG/PNG)
        <input type="file" name="file" class="mt-1 w-full rounded-md border-gray-300" />
      </label>
    </div>
    <div class="flex justify-end gap-2">
      <a href="{{ route('expenses.index') }}" class="rounded-md border px-4 py-2 hover:bg-gray-50">Abbrechen</a>
      <button class="rounded-md bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">Speichern</button>
    </div>
  </form>
</x-layout>
