<x-layout :title="'Kategorien'">
  <div class="mx-auto max-w-3xl space-y-4">
    <form method="post" action="{{ route('categories.store') }}" class="rounded-xl border bg-white p-6 shadow-sm">
      @csrf
      <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
        <input name="name" placeholder="Neue Kategorie" required class="sm:col-span-2 rounded-md border-gray-300" />
        <input type="number" name="budget" step="0.01" placeholder="Teilbudget (optional)" class="rounded-md border-gray-300" />
      </div>
      <div class="mt-4 flex justify-end">
        <button class="rounded-md bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">Hinzufügen</button>
      </div>
    </form>

    <div class="rounded-xl border bg-white p-6 shadow-sm">
      <h3 class="mb-3 text-lg font-semibold">Bestehende Kategorien</h3>
      <ul class="divide-y">
        @foreach(\App\Models\Category::orderBy('name')->get() as $c)
          <li class="py-2 flex justify-between">
            <span>{{ $c->name }}</span>
            <span class="text-gray-500 text-sm">
              @if($c->budget) Budget: {{ number_format($c->budget,2,',','.') }} € @else — @endif
            </span>
          </li>
        @endforeach
      </ul>
    </div>
  </div>
</x-layout>
