<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder {
  public function run(): void {
    DB::table('settings')->updateOrInsert(['key'=>'total_budget'], ['value'=>'160000.00']);
    DB::table('settings')->updateOrInsert(['key'=>'purchase_price'], ['value'=>'160000.00']);
    DB::table('settings')->updateOrInsert(['key'=>'grunderwerbsteuer_rate'], ['value'=>'6.5']);
    DB::table('settings')->updateOrInsert(['key'=>'notary_land_reg_rate'], ['value'=>'2.0']);
    if (DB::table('categories')->count() === 0) {
      DB::table('categories')->insert([
        ['name'=>'Rohbau','budget'=>60000],
        ['name'=>'Elektro','budget'=>15000],
        ['name'=>'Sanitär/Heizung','budget'=>20000],
        ['name'=>'Fenster/Türen','budget'=>12000],
        ['name'=>'Planung/Genehmigungen','budget'=>5000],
      ]);
    }
  }
}
