<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('expenses', function (Blueprint $t) {
      $t->id();
      $t->foreignId('category_id')->nullable()->constrained()->nullOnDelete();
      $t->date('date');
      $t->string('vendor')->nullable();
      $t->string('invoice_number')->nullable();
      $t->decimal('net_amount', 12, 2);
      $t->decimal('tax_rate', 5, 2)->default(19.00);
      $t->decimal('gross_amount', 12, 2);
      $t->string('file_path')->nullable();
      $t->timestamps();
      $t->index(['date','category_id']);
    });
  }
  public function down(): void { Schema::dropIfExists('expenses'); }
};
