<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model {
  protected $fillable = [
    'category_id','date','vendor','invoice_number',
    'net_amount','tax_rate','gross_amount','file_path'
  ];
  protected $casts = ['date'=>'date'];

  protected static function booted(){
    static::saving(function($m){
      $m->gross_amount = round($m->net_amount * (1 + $m->tax_rate/100), 2);
    });
  }
  public function category(){ return $this->belongsTo(Category::class); }
}
