<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

class StoreExpenseRequest extends FormRequest {
  public function authorize(): bool { return true; }
  public function rules(): array {
    return [
      'date' => ['required','date'],
      'category_id' => ['nullable','exists:categories,id'],
      'vendor' => ['nullable','max:255'],
      'invoice_number' => ['nullable','max:255'],
      'net_amount' => ['required','numeric','min:0'],
      'tax_rate' => ['required','numeric','between:0,100'],
      'file' => ['nullable','file','mimes:pdf,jpg,jpeg,png','max:30720'],
    ];
  }
}
