<?php
namespace App\Http\Controllers;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller {
  public function edit(){
    $totalBudget = Setting::get('total_budget', 160000);
    $purchasePrice = (float) Setting::get('purchase_price', 160000);
    $grEStRate = (float) Setting::get('grunderwerbsteuer_rate', 6.5);
    $notaryRate = (float) Setting::get('notary_land_reg_rate', 2.0);
    return view('settings.edit', compact('totalBudget','purchasePrice','grEStRate','notaryRate'));
  }
  public function update(Request $r){
    $r->validate([
      'total_budget'=>['required','numeric','min:0'],
      'purchase_price'=>['required','numeric','min:0'],
      'grunderwerbsteuer_rate'=>['required','numeric','min:0','max:100'],
      'notary_land_reg_rate'=>['required','numeric','min:0','max:100'],
    ]);
    Setting::set('total_budget', $r->total_budget);
    Setting::set('purchase_price', $r->purchase_price);
    Setting::set('grunderwerbsteuer_rate', $r->grunderwerbsteuer_rate);
    Setting::set('notary_land_reg_rate', $r->notary_land_reg_rate);
    return back()->with('ok','Einstellungen gespeichert');
  }
}
