<?php
namespace App\Exports;
use App\Models\Expense;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ExpensesExport implements FromCollection, WithHeadings, WithMapping
{
  public function __construct(private array $filters=[]) {}

  public function collection(){
    $q = Expense::with('category')->orderBy('date');
    if(!empty($this->filters['category_id'])) $q->where('category_id',$this->filters['category_id']);
    if(!empty($this->filters['from'])) $q->whereDate('date','>=',$this->filters['from']);
    if(!empty($this->filters['to'])) $q->whereDate('date','<=',$this->filters['to']);
    return $q->get();
  }

  public function headings(): array {
    return ['Datum','Kategorie','Lieferant','Rechnungsnr.','Netto','MwSt %','Brutto','Datei'];
  }

  public function map($e): array {
    return [
      $e->date?->format('Y-m-d'),
      optional($e->category)->name,
      $e->vendor,
      $e->invoice_number,
      number_format($e->net_amount,2,',','.'),
      number_format($e->tax_rate,2,',','.'),
      number_format($e->gross_amount,2,',','.'),
      $e->file_path ? url('storage/'.$e->file_path) : '',
    ];
  }
}
